const path = require('path');
const config = require('./webpackConfig');
const CopyWebpackPlugin = require('copy-webpack-plugin');

module.exports = {
    devtool: 'eval',
    mode: 'development',
    entry: {
        app: './assets/index.js',
    },
    output: {
        path: path.resolve(__dirname, './app.www/build/'),
        filename: '[name].bundle.js',
        libraryTarget: 'window',
    },
    externals: {
        jquery: 'jQuery',
        swa: 'swa',
        teamwork: 'teamwork',
        utils: 'TBUtils',
        react: 'react',
        'react-dom': 'react-dom',
        graphql: 'graphql',
        TB: 'TB',
    },
    resolve: {
        mainFields: ['browser', 'main', 'module'],
        extensions: ['.wasm', '.js', '.jsx', '.json'],
    },
    module: {
        rules: config.moduleRules,
    },
    plugins: [
        new CopyWebpackPlugin({
            patterns: [
                {
                    from: path.resolve(__dirname, 'assets', 'images'),
                    to: 'images',
                },
            ],
        }),
    ],
};
