const path = require('path');

module.exports = {
    moduleRules: [
        {
            test: /\.(js|jsx)$/,
            include: [path.resolve(__dirname, './assets')],
            use: ['babel-loader'],
        },
        {
            test: /\.flow$/,
            use: ['ignore-loader'],
        },
        {
            test: /\.css$/,
            use: ['style-loader', 'css-loader'],
        },
        {
            test: /\.scss$/,
            use: ['style-loader', 'css-loader', 'sass-loader'],
        },
        {
            test: /\.svg$/,
            use: {
                loader: 'svg-url-loader',
                options: {},
            },
            include: function(input) {
                // only process modules with this loader
                // if they live under an 'images' directory
                return input.indexOf('images') > -1;
            },
        },
        {
            test: /\.eot|.svg|.woff|.woff2|.ttf$/,
            loader: 'url-loader',
            options: {
                // Limit at 50k. Above that it emits separate files
                limit: 50000,
                name: 'fonts/[name].[ext]',
            },
            include: function(input) {
                // only process modules with this loader
                // if they live under a 'fonts' directory
                return input.indexOf('fonts') > -1;
            },
        },
        {
            test: /\.(jpe?g|png|gif)$/i,
            use: ['url-loader?limit=50000', 'img-loader'],
        },
    ],
};
