# create-tb-app

create-tb-app is a template, it provides the required shell for a TopBraid Application that will define JavaScript extensions.  

To get started:
- [ ] Clone or copy the entire folder structure.
- [ ] Find all instances of 'create-tb-app' and apply your own name.
- [ ] There is no license defined in the package.json, you would have to provide your own.
 

This shell defines several external libraries that the developer can rely on existing within the TopBraid EDG ecosystem.  Webpack has been configured such that the following libraries will always be considered external and therefore will not be bundled.

- React
- ReactDOM
- Graphql
- jQuery

- swa

  swa is the legacy javascript library originally developed to support SWP.  Not all features of EDG are React based and may require interaction with these legacy API's.  Use of the swa namespace should be limited as the functions may be deprecated.

   `import * as swa from 'swa';`

- teamwork

    Similar to the swa namespace, the teamwork namespace is available, but it's use should be limited as the functions may be deprecated.

   `import * as teamwork from 'teamwork';`

- TB

    TB is a namespace that contains the recent editor React APIs and Components.  

    Import evertyhing or target specific modules with named imports.

    `import * as TB from 'TB';`

    `import {Panel, AppContext, PanelTypes} from 'TB';`


## Asset Managment
create-tb-app is setup to utilize yarn package manager and webpack bundler.


Yarn is managing any and all JavaScript/CSS dependecies. 

To add a package:

 `yarn add -D [pkg-name]` (saves package as a development dependency)

To remove a package:

   `yarn remove [pkg-name]`

[Full Yarn Documentation](https://yarnpkg.com/en/docs)

Webpack is bundling all of the static assets into a single bundle.  More advanced features such as code splitting would be possible, but are not covered by this template.

The webpack configuration is broke down into several files.  webpackConfig.js, webpack.dev.js, webpack.prod.js.

webpackConfig.js defines the common moduleRules that both dev and productoin systems would required.  These moduleRules are how webpack determines to handle a given file (based on extension).
[Loader Documentation](https://webpack.js.org/concepts/#loaders)


Largely webpack.dev and webpack.prod have the same configuration, so why offer both?  A production build offers optimizations such as minification, and setting the build environment [mode](https://webpack.js.org/configuration/mode/).



[Full Webpack Documention](https://webpack.js.org/concepts/)


## Building

There are a series of scripts pre-defined to help get things rolling.  After cloning this template and renaming install all of the dependencies

`yarn install`

After the dependencies are installed.  Run the production build.  (Note: A build is **required** after any change to a static asset)

`yarn run build`

**Pro Tip**:
When activily developing it can be combersome to continally execute the build command.  Instead 'watch' the files:

`yarn run watch:prod`

This will monitor the 'assets' directory of this project for any changes, if discovered it will auto-build the necessary files.  Keep in mind for use in production the build command should be explicitly executed.


## Deployment
create-tb-app is also a TopBraid Composer project, which allows it to be imported into a TBC workspace or deployed to a Tomcat EDG installation.

For use with TBC simply import the project into a TBC workspace.

For use with Tomcat, zip the folders contents and deploy the project with 'Project Upload'.

create-tb-app offers an easy way to produce a deployable zip for EDG.

`yarn run zip` 

Note: windows users, this script will not work for you take note of the files/folders that are ignored when building a deployable zip.


When executed this will produce a zip of the current folder structure but will exclude all of the unnecessary files for runtime (listed below).
- assets
- .DS_Store
- .gitignore
- .git
- .prettierrc
- .eslintrc.js
- babel.config.js
- .yarnrc
- yarn-lock
- webpack.dev.js
- webpack.prod.js
- webpackConfig.js
- .keep
- node_modules
- README.md


## Other Scripts

`yarn run build:prod` 
`yarn run build:dev`
`yarn run watch:dev`  
`yarn run analyze` (this command will produce a bundle analysis report)
`yarn run stats` (this command will produce a stats.json file that can be used in other reporting tools)
